from OpenGL.GL import *
from pygame.locals import *
from math import *
import shader
import array
import pygame
import time
import sys
from random import random

X = 900
Y = 900

def init():    
    global texID

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)
    shader.create(X, Y)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    texID = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

def jitter(): return (random()*2 - 1) * 0.01

theta = 0
x = random()*2 - 1
y = 1.1
vx = -x/25*random()
vy = 0

def draw():
    global vx, vy, x, y, theta
    theta += 1

    # draw the texture
    shader.enable()
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)
    glBegin(GL_QUADS)
    glVertex3f(-1.00, -1, 0); glTexCoord2i(1, 0)
    glVertex3f(1.00, -1, 0);  glTexCoord2i(1, 1)
    glVertex3f(1.00, 1.000, 0);   glTexCoord2i(0, 1)
    glVertex3f(-1.00, 1.000, 0);  glTexCoord2i(0, 0)
    glEnd()
    shader.disable()

    # draw something
    glDisable(GL_TEXTURE_2D)
    glColor3f(1, 0.5, 0.5)

    glPushMatrix();

    if y > -0.95:
        glTranslatef(x, y, 0)
    elif y > -1.5:
        glTranslatef(x, -0.95, 0)
        glScalef(10*(0.05-y)-9, 10*(0.05-y)-9, 1)
    else:
        x = random()*2 - 1
        y = 1.1
        vx = -x/25 * random()
        vy = -0.02
        glTranslatef(x, y, 0)

    x += vx
    y += vy

    vy -= 0.002

    glPointSize(1.5)
    glBegin(GL_POINTS)
    for i in xrange(1000):
        glColor3f(1, random()*0.8, 0)
        glVertex3f(3*(jitter()+jitter()+jitter()), 3*(jitter()+jitter()+jitter()), -1)
    glEnd()
    glPopMatrix();

    glPointSize(1)
    glColor4f(0.125, 0.0, 0.0, 0.5)
    glBegin(GL_POINTS)
    for i in xrange(2000):
        glVertex3f(random()*2-1, random()*2-1, 0)
    glEnd()

    
    # copy it into a texture
    glBindTexture(GL_TEXTURE_2D, texID)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)

def mainloop():
    glClearColor(0, 0, 0, 0)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.001)
